#include "map.h"

long pion_case(long x, long y, t_pion *pions, long nbr_pions);

// Charge une map a partir d'un fichier .map
void charger_map(t_map *map)
{
    long n,x,y,tilemax; // Compteurs d'indice, de position, et nombre de tiles.
    char kmap_str[5]; // Contient la chaine de caractre d'indication du fichier map
    char c; // Contient l'octet prcdemment obtenu

    kmap_str[0]=0; //On initialise la chaine de caractre du KMAP
    FILE* fichier=NULL; // Pointeur sur le fichier .map  charger

    // On dfinit le fichier de la map
    ///map->fichier=(char *)malloc(SAISIE_MAX+1); // On alloue le nom du fichier

    fichier=fopen(map->fichier,"rb"); // On ouvre le fichier en LECTURE BINAIRE SEULE


    if (fichier) // Si un fichier a pu tre ouvert alors On charge ^^
    {
        fscanf(fichier,"%4s",kmap_str); // On rcupre les 4 premiers caractres


        if (strcmp("KMAP", kmap_str) == 0) // On verifie que le fichier commence bien par KMAP, preuve que le fichier est bien une map
        {
        /// CHARGEMENT DU TILESET
            do
            {
                c = fgetc(fichier); // On rcupre le caractre
            }while(c != 0);
            charger_tileset(&(map->tileset), 0);
        /*
            // On dfinit le fichier du Tileset (la grille des diffrents terrains)
            map->tileset.fichier=(char *)malloc(SAISIE_MAX+1); // On alloue le nom du fichier

            // Remarque: On alloue l encore la taille d'une saisie car cette valeur est susceptible d'tre modifie
            n=0;// On initialise le compteur d'indice

            while(1);
            // Boucle Do...While pour capturer le nom du fichier
            do
            {
                c=fgetc(fichier); // On rcupre le caractre
                map->tileset.fichier[n]=c; // Et on le rajoute au nom du fichier
                n++; // ON n'oublie pas d'incrmenter l'indice
            }while(c!=0); // Le caractre EOT permet de dfinir la fin du nom du fichier

        /// Chargement du Tileset

            if ( charger_tileset(&map->tileset,0))
            {

                sprintf(map->tileset.fichier,"map.png"); // Par dfaut: map.png
                if ( charger_tileset(&map->tileset,0))
                {
                    printf ( "Impossible de charger l'image par dfaut. On Quitte");
                    exit(EXIT_FAILURE);
                }
            }*/


            // On dfinit le fichier des effets
            map->fx.fichier=(char *)malloc(strlen(RESSOURCES_DIR)+strlen(FX_FICHIER)+1);
            sprintf(map->fx.fichier,"%sfx.png",RESSOURCES_DIR); // Par dfaut, c'est "fx.png" mais pourra tre chang dans les options du jeu

            if ( charger_tileset(&map->fx,1))
            {

                sprintf(map->fx.fichier,"%sfx.png",RESSOURCES_DIR); // Par dfaut: map.png
                if (charger_tileset(&map->fx,1))
                {
                    printf ( "Impossible de charger l'image d'effet par dfaut. On Quitte");
                    exit(EXIT_FAILURE);
                }
            }

            tilemax=(long)fgetc(fichier); // L'octet suivant contient le nombre de tiles

            if (tilemax!=map->tileset.largeur*map->tileset.hauteur) // Si le tileset ne contient pas le mme nombre de tiles que celles definies dans la map
            {
                printf ( "ERREUR la taille des tilesets ne correspond pas !!!"); // ERREUR
                exit (EXIT_FAILURE); // Et arrt
            }

            // On alloue les tiles en fonction de la taille du Tileset
            map->tile=(t_tile*)malloc(tilemax*sizeof(t_tile));
            for (n=0;n<tilemax;n++) // On parcourt toutes les tiles
            {
                map->tile[n].type=fgetc(fichier); // Le premier octet dfinit le type de terrain
                map->tile[n].frame=0; // On commence l'animation  la premire image
                map->tile[n].cout_pts=fgetc(fichier); // L'octet suivant dfinit le cout en points de mouvement

                // Les 3 octets d'aprs dfinissent les composantes de la couleur de la tile dans la minimap
                map->tile[n].couleur.r=fgetc(fichier); // D'abord le Rouge
                map->tile[n].couleur.g=fgetc(fichier); // Puis le Vert
                map->tile[n].couleur.b=fgetc(fichier); // Et enfin le Bleu

                // Le mme format est rept pour chaque tile
            }

            // La taille de la map est stocke sur 2 octets (255*255 max)
            map->largeur=fgetc(fichier); // 1octet pour la Taille de la map en largeur
            map->hauteur=fgetc(fichier); // 1octet pour la Taille de la map en hauteur

            // On initialise les cases de la map

            map->cases=(t_map_case**)malloc(map->hauteur*sizeof(t_map_case*)); // Allocation des pointeurs sur les lignes de cases

            // Les types de tile sont placs  la suite de gauche  droite, et de bas en haut
            for (y=0;y<map->hauteur;y++) // On explore donc tout ligne par ligne
            {
                 map->cases[y]=(t_map_case*)malloc(map->largeur*sizeof(t_map_case)); // Allocation des pointeurs sur les cases
                for (x=0;x<map->largeur;x++) //  DE gauche  droite
                {
                    map->cases[y][x].tile=fgetc(fichier);// 1octet pour le type de tile de la case
                    map->cases[y][x].etat=INCONNU;
                }
            }

            c=fgetc(fichier); // Rcupration du caractre sens tre le dernier
            if(!feof(fichier)) // Si ce caractre n'tait pas le caractre EOF
            {
                printf("Chargement de la MAP: Fin de fichier non atteinte"); // On considre qu'il y a une incohrence dans le fichier
                exit (EXIT_FAILURE); // Alors on quitte
            }
        }
        else // Si les 4 permieres caractres ne sont pas "KMAP"
        {
            printf("Chargement de la MAP: le filetype ne correspond pas : %s", map->fichier); // Le fichier n'est donc pas une map
            exit (EXIT_FAILURE); // Alors on quitte
        }

        fclose(fichier); // On ferme le fichier
    }
    else // Si le fichier n'a pas pu tre charg
    {
        printf("Impossible de charger la map"); // Le fichier n'est donc pas une map
        exit (EXIT_FAILURE); // Alors on quitte
    }
}

// Supprime les donnes de l'interface
void liberer_map(t_map * map) //dite le 25/02/2010  13:45 par Loc
{
    long y; // Compteur de ligne
    free(map->fichier); // On libre le nom du fichier de la Map
    free(map->tileset.fichier); // On libre le nom du fichier du Tileset
    SDL_FreeSurface(map->tileset.image); // On libre la surface du Tileset
    free(map->fx.fichier);  // On libre le nom du fichier des effets
    SDL_FreeSurface(map->fx.image); // On libre la surface des effets
    free(map->tile); // On libre la liste des tiles

    // On explore les lignes de la map
    for (y=0;y<map->hauteur;y++)
    {
        free(map->cases[y]); // On libre les cases de la ligne
    }
    free(map->cases); // Puis on libre les lignes

    // la structure de la map sera libre automatiquement  la fin du main
}

// Blitte la map sur l'cran
void afficher_map (t_map* map,t_interface* interface)
{
    long x,y; // Compteurs de position
    SDL_Rect position, crop; // Coordonnes de positionnement, et de rognage

    // On rogne le tileset pour n'avoir qu'une seule tile....
    crop.h=TILE_TAILLE;
    crop.w=TILE_TAILLE;
    SDL_FillRect(interface->gui[0]->image, 0, SDL_MapRGB(interface->fenetre->format, 0,0,0)); // On efface l'cran

    // On affiche ligne par ligne, de gauche  droite, de bas en haut
    for (y=(interface->gui[0]->crop.y/TILE_TAILLE);y<=((interface->gui[0]->crop.y+interface->gui[0]->crop.h)/TILE_TAILLE);y++) // On ne prend que les tiles qui sont dans l'cran
    {
        for (x=(interface->gui[0]->crop.x/TILE_TAILLE);x<=((interface->gui[0]->crop.x+interface->gui[0]->crop.w)/TILE_TAILLE)+1;x++)// On ne prend que les tiles qui sont dans l'cran
        {
            position.x=x*TILE_TAILLE-interface->gui[0]->crop.x; // On transforme les coordonnes de la tile en coordonnes en pixels
            position.y=y*TILE_TAILLE-interface->gui[0]->crop.y;   // On transforme les coordonnes de la tile en coordonnes en pixels

            if (x>=0 && y>=0 && x<map->largeur && y<map->hauteur) // Si les coordonnes sont bien celles d'une tile de la map (voir remarque ci dessous)
            {
                /*  Remarque
                    Cette condition est necessaire car on peut si on le veut, permettre  l'cran de sortir de la map...
                */

                // On rcupre les coordonnes de rognage de la tile identifie par son numro
                conversion_tile_tileset(map->cases[y][x].tile,map->tileset.largeur,map->tileset.hauteur,&crop);
                if (map->cases[y][x].etat == VISIBLE || interface->options.poulette)
                {
                    // On blitte cette le tileset rogne (donc la tile),  la bonne position sur l'ecran
                    SDL_BlitSurface(map->tileset.image, &crop, interface->gui[0]->image, &position);
                }
                else if  (map->cases[y][x].etat == MASQUE)
                {
                    map->tileset.image->format->Amask=0;
                    SDL_SetAlpha(map->tileset.image,SDL_SRCALPHA,128);

                    SDL_BlitSurface(map->tileset.image, &crop, interface->gui[0]->image, &position);

                    map->tileset.image->format->Amask=AMASK;
                    SDL_SetAlpha(map->tileset.image,SDL_SRCALPHA,255);
                }
            }
        }
    }
}

// Actualise la minimap  partir des donnes de la map
void actualiser_minimap (t_partie *jeu, t_interface* interface)
{
    long t;
    long minimap_element;
    SDL_Surface* pixel; //Contient un unique pixel
    SDL_Color couleur;
    SDL_Rect position; //Position du pixel sur la minimap
    double ratio; //Ratio d'agrandissement
    long x, y, i, j; //Positions sur la carte / avancement sur la minimap
    long offset_x, offset_y; //Utiliss pour centrer la minimap
    double r[160][160], g[160][160], b[160][160], coeff[160][160]; //Contiennent les calculs en cours
    double coeff_x, coeff_y, temp_x, temp_y, temp;

    minimap_element=obtenir_element(interface,MINIMAP);

    if (minimap_element!=-1)
    {
        //Calcul du ratio optimal pour l'agrandissement
        if(jeu->map.largeur < jeu->map.hauteur)
        {
            ratio = 160.0 / jeu->map.hauteur;
            offset_x = (160.0 - jeu->map.largeur * ratio) / 2;
            offset_y = 0;
        }
        else
        {
            ratio = 160.0 / jeu->map.largeur;
            offset_x = 0;
            offset_y = (160.0 - jeu->map.hauteur * ratio) / 2;
        }

        //Initialisation des couleurs : noir
        SDL_FillRect(interface->gui[minimap_element]->image, NULL, SDL_MapRGB(interface->gui[minimap_element]->image->format, 0, 0, 0));
        for (y = 0; y < 160; y++)
        {
            for (x = 0; x < 160; x++)
            {
                r[y][x] = 0.0; g[y][x] = 0.0; b[y][x] = 0.0; coeff[y][x] = 0.0;
            }
        }

        //Pour chaque case de la carte
        //Pour chaque ligne
        for(y = 0; y < jeu->map.hauteur; y++)
        {
            i = 0;
            coeff_y = (long)(y * ratio) + 1 - y * ratio;
            do
            {
                if(coeff_y > 1) {temp_y = 1.0;}
                else {temp_y = coeff_y;}

                //Pour chaque colonne
                for(x = 0; x < jeu->map.largeur; x++)
                {
                    j = 0;
                    coeff_x = (long)(x * ratio) + 1 - x * ratio;

                    couleur.r=jeu->map.tile[jeu->map.cases[y][x].tile].couleur.r;
                    couleur.g=jeu->map.tile[jeu->map.cases[y][x].tile].couleur.g;
                    couleur.b=jeu->map.tile[jeu->map.cases[y][x].tile].couleur.b;

                    if (jeu->map.cases[y][x].etat==VISIBLE || interface->options.poulette)
                    {
                        if(ratio > 1)
                        {
                            t = pion_case(x, y, jeu->pions, jeu->nbr_pions);
                            if(t != -1)
                            {
                                couleur = jeu->joueurs[jeu->pions[t].joueur].couleur;
                            }
                        }
                    }
                    else if (jeu->map.cases[y][x].etat==INCONNU)
                    {
                        couleur.r=0;
                        couleur.g=0;
                        couleur.b=0;
                    }
                    else if (jeu->map.cases[y][x].etat==MASQUE)
                    {
                        couleur.r/=2;
                        couleur.g/=2;
                        couleur.b/=2;
                    }


                    do
                    {
                        if(coeff_x > 1) {temp_x = 1.0;}
                        else {temp_x = coeff_x;}
                        temp = temp_x * temp_y;
                        coeff[(long)(y * ratio) + offset_y + i][(long)(x * ratio) + offset_x + j] += temp;
                        r[(long)(y * ratio) + offset_y + i][(long)(x * ratio) + offset_x + j] += couleur.r  * temp;
                        g[(long)(y * ratio) + offset_y + i][(long)(x * ratio) + offset_x + j] += couleur.g * temp;
                        b[(long)(y * ratio) + offset_y + i][(long)(x * ratio) + offset_x + j] += couleur.b * temp;
                        if(j == 0) {coeff_x = (x + 1) * ratio - (long)(x * ratio) - 1;}
                        else {coeff_x -= 1.0;}
                        j++;
                    }while(coeff_x > 0.01);
                }

                if(i == 0) {coeff_y = (y + 1) * ratio - (long)(y * ratio) - 1;}
                else {coeff_y -= 1.0;}
                i++;
            }while(coeff_y > 0.01);
        }

        if(ratio <= 1)
        {
            for(y = 0; y < jeu->map.hauteur; y++)
            {
                for(x = 0; x < jeu->map.largeur; x++)
                {
                    if(jeu->map.cases[y][x].etat == VISIBLE || interface->options.poulette)
                    {
                        t = pion_case(x, y, jeu->pions, jeu->nbr_pions);
                        if(t != -1)
                        {
                            r[(long)(y * ratio) + offset_y][(long)(x * ratio) + offset_x] = jeu->joueurs[jeu->pions[t].joueur].couleur.r;
                            g[(long)(y * ratio) + offset_y][(long)(x * ratio) + offset_x] = jeu->joueurs[jeu->pions[t].joueur].couleur.g;
                            b[(long)(y * ratio) + offset_y][(long)(x * ratio) + offset_x] = jeu->joueurs[jeu->pions[t].joueur].couleur.b;
                            coeff[(long)(y * ratio) + offset_y][(long)(x * ratio) + offset_x] = 1.0;
                        }
                    }
                }
            }
        }

        //On range le rsultat dans la surface prvue pour la minimap
        pixel = SDL_CreateRGBSurface(SDL_HWSURFACE, 1, 1, BITSPERPIXEL, 0, 0, 0, 0);
        for (position.y = 0; position.y < 160; position.y++)
        {
            for (position.x = 0; position.x < 160; position.x++)
            {
                if(coeff[position.y][position.x] != 0)
                {
                    SDL_FillRect(pixel, NULL, SDL_MapRGB(interface->gui[minimap_element]->image->format, r[position.y][position.x] / coeff[position.y][position.x], g[position.y][position.x] / coeff[position.y][position.x], b[position.y][position.x] / coeff[position.y][position.x]));
                    SDL_BlitSurface(pixel, 0, interface->gui[minimap_element]->image, &position);
                }
            }
        }
        SDL_FreeSurface(pixel);
        return;
    }
    else
    {
        printf("Impossible d'obtenir l'element de la minimap");
    }

}
 // Recupre les coordonnes de rognage d'un tileset  partir du numro de tile
void conversion_tile_tileset(long tile, long largeur,long hauteur, SDL_Rect *crop)
{
    long n;

    n=tile%(largeur*hauteur);
    /// A changer: On ne passera plus largeur et hauteur, mais directement le pointeur sur le tileset !!!
    crop->x = (n%largeur)*TILE_TAILLE;// Bord gauche de la tile
    crop->y = (n/largeur)*TILE_TAILLE;// Bord haut de la tile


}

// Obtient les coordonnes de la case situe sous le pointeur de la souris
void obtenir_case(t_interface* interface)
{
    interface->curseur.x=(interface->gui[0]->crop.x+interface->pointeur.x); // Position du pointeur dans la map en pixels selon X
    interface->curseur.y=(interface->gui[0]->crop.y+interface->pointeur.y); // Position du pointeur dans la map en pixels selon Y

    if (interface->curseur.x<0 || interface->curseur.y<0) // Si la position est ngative (en dehors de la map)
    {
       interface->curseur.x=-1; // Alors on donne x=-1
       interface->curseur.y=-1; // Et y=-1 pour indiquer que le curseur n'est pas sur la map...
    }
    else // Sinon
    {
         // On transforme la coordonnes pixels en coordonnes cases en divisant par la taille d'une tile
        interface->curseur.x/=TILE_TAILLE; // Coordonnes en X
        interface->curseur.y/=TILE_TAILLE; // Coordonnes en Y
    }
}

long pion_case(long x, long y, t_pion *pions, long nbr_pions)
{
    long i; //Compteur qui parcourt les pions

    for(i = 0; i < nbr_pions; i++) //Pour chaque pion de la liste
    {
        if(pions[i].pos_x == x && pions[i].pos_y == y) {return i;} //Si on a trouv le pion on le renvoie
    }
    return -1; //Sinon il n'y a pas de pion sur la case
}
